/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.teastory.blockentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import xueluoanping.teastory.block.entity.SyncedBlockEntity;
import xueluoanping.teastory.registry.BlockEntityRegister;

public class WoodenBarrelBlockEntity
extends SyncedBlockEntity {
    private final LazyOptional<FluidTank> fluidTank = LazyOptional.of(this::createFluidHandler);
    private Fluid remainFluid = Fluids.f_76191_;
    private final int capacity;
    private int heightAmount = 0;

    public WoodenBarrelBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegister.WOODEN_BARREL_TYPE.get(), pos, state);
        this.capacity = 4000;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (!this.m_58901_() && ForgeCapabilities.FLUID_HANDLER.equals(cap)) {
            return this.fluidTank.cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.fluidTank.ifPresent(f -> {
            f.readFromNBT(tag.m_128469_("FluidTank"));
            this.recordPreviousFluid(f.getFluid());
        });
    }

    protected void m_183515_(CompoundTag tag) {
        this.fluidTank.ifPresent(f -> tag.m_128365_("FluidTank", (Tag)f.writeToNBT(new CompoundTag())));
        super.m_183515_(tag);
    }

    private FluidTank createFluidHandler() {
        return new FluidTank(this.capacity){

            protected void onContentsChanged() {
                WoodenBarrelBlockEntity.this.recordPreviousFluid(this.fluid);
                WoodenBarrelBlockEntity.this.inventoryChanged();
            }

            public boolean isFluidValid(FluidStack stack) {
                return !stack.getFluid().getFluidType().isLighterThanAir() && stack.getFluid().getFluidType().getTemperature() < 500;
            }
        };
    }

    public FluidTank getFluidTank() {
        return (FluidTank)this.fluidTank.orElse((Object)new FluidTank(0));
    }

    public Fluid getFluid() {
        return this.fluidTank.map(f -> f.getFluid().getFluid()).orElse(Fluids.f_76191_);
    }

    public int getFluidAmount() {
        return this.getFluidTank().getFluidAmount();
    }

    public void setFluidTank(FluidStack stack) {
        this.fluidTank.ifPresent(f -> f.setFluid(stack));
    }

    public void setFluid(Fluid fluid) {
        this.fluidTank.ifPresent(f -> f.setFluid(new FluidStack(fluid, this.getFluidAmount())));
        this.inventoryChanged();
    }

    public void recordPreviousFluid(FluidStack fluid) {
        if (!fluid.isEmpty() && fluid.getAmount() > 0) {
            this.remainFluid = fluid.getFluid();
        }
    }

    public Fluid getRemainFluid() {
        return this.remainFluid;
    }

    private void updateHeight() {
        if (this.f_58857_.m_5776_()) {
            int viscosity = Math.max(this.remainFluid.getFluidType().getViscosity() / 50, 10);
            if (this.heightAmount > this.getFluidAmount()) {
                this.heightAmount -= Math.max(1, (this.heightAmount - this.getFluidAmount()) / viscosity);
            } else if (this.heightAmount < this.getFluidAmount()) {
                this.heightAmount += Math.max(1, (this.getFluidAmount() - this.heightAmount) / viscosity);
            }
        }
    }

    public float getHeight() {
        this.updateHeight();
        return 0.0625f + 0.875f * (float)this.heightAmount / (float)this.capacity;
    }
}

